#include "StdAfx.h"

#include <stdio.h>
#include <iostream>
#include <fstream>
#include <sstream> 
#include <map>
#include <algorithm>

#include "UnequalIntervalScale.h"

using namespace std;

CUnequalIntervalScale::CUnequalIntervalScale(void)
{
	adjustMode = NORMAL;
	developerMode = false;

	adjustValue = 0;
	angle = 0;
	rotateAngle = 0;
}

CUnequalIntervalScale::~CUnequalIntervalScale(void)
{
}

void CUnequalIntervalScale::CsvParse(tstring path)
{
	// CSVt@C̓ǂݍ
	tifstream ifs(path.c_str());

	tstring str; // s
	tstring element; // vf

	// CSVt@C̍sǂݍ
	while (ifs && getline(ifs, str))
	{
		int colCnt = 0; // JE^[
		bool addFlag = true; // XgǉtO
		double x = 0;
		double y = 0;

		// s𕶎Xg[
		tistringstream row(str);

		// CSVt@C̊eړǂݍ
		while (getline(row, element, _T(',')))
		{
			// 𐔒lɕϊ
			tstringstream ss;
			double value;

			ss << element;
			ss >> value;

			// p[^̓o^
			switch (colCnt)
			{
			case 0:
				// 1ځi͒lj
				x = value;
				break;
			case 1:
				// 2ځio͊pxj
				y = value;
				break;
			}

			// l̓ǂݍ݂ɎsꍇAXg̒ǉȂ
			if (ss.fail())
			{
				addFlag = false;
				break;
			}

			colCnt++;
		}

		// ɓǂݍ߂ꍇ̂݃p[^ǉ
		if (colCnt >= 2 && addFlag)
		{
			params[x] = y; // map͒ǉɎ\[g
		}
	}
}

void CUnequalIntervalScale::SetAdjustStep(double step)
{
	adjustStep = fabs(step);
}

void CUnequalIntervalScale::SetAngleStep(double step)
{
	angleStep = fabs(step);
}

void CUnequalIntervalScale::SetRotateStep(double step)
{
	rotateStep = step;
}

void CUnequalIntervalScale::SetDeveloperMode(int enabled)
{
	developerMode = enabled;
}

void CUnequalIntervalScale::SwitchAdjustMode(void)
{
	if (developerMode)
	{
		switch (adjustMode)
		{
		case NORMAL:
			adjustMode = ADJUST;
			break;
		case ADJUST:
			adjustMode = VERIFY;
			break;
		case VERIFY:
			adjustMode = ROTATE;
			break;
		case ROTATE:
			adjustMode = NORMAL;
			rotateAngle = 0;
			break;
		}
	}
}

void CUnequalIntervalScale::ResetAdjustValue(void)
{
	if (adjustMode == VERIFY)
	{
		adjustValue = 0;
	}
	else if (adjustMode == ADJUST)
	{
		angle = 0;
	}
}

void CUnequalIntervalScale::AdjustIncrementLarge(void)
{
	if (adjustMode == VERIFY)
	{
		adjustValue += adjustStep * 10;
	}
	else if (adjustMode == ADJUST)
	{
		angle += angleStep * 10;
	}
}

void CUnequalIntervalScale::AdjustIncrementMedium(void)
{
	if (adjustMode == VERIFY)
	{
		adjustValue += adjustStep;
	}
	else if (adjustMode == ADJUST)
	{
		angle += angleStep;
	}
}

void CUnequalIntervalScale::AdjustIncrementSmall(void)
{
	if (adjustMode == VERIFY)
	{
		adjustValue += adjustStep / 10;
	}
	else if (adjustMode == ADJUST)
	{
		angle += angleStep * 0.1;
	}
}

void CUnequalIntervalScale::AdjustDecrementLarge(void)
{
	if (adjustMode == VERIFY)
	{
		adjustValue -= adjustStep * 10;
	}
	else if (adjustMode == ADJUST)
	{
		angle -= angleStep * 10;
	}
}

void CUnequalIntervalScale::AdjustDecrementMedium(void)
{
	if (adjustMode == VERIFY)
	{
		adjustValue -= adjustStep;
	}
	else if (adjustMode == ADJUST)
	{
		angle -= angleStep;
	}
}

void CUnequalIntervalScale::AdjustDecrementSmall(void)
{
	if (adjustMode == VERIFY)
	{
		adjustValue -= adjustStep / 10;
	}
	else if (adjustMode == ADJUST)
	{
		angle -= angleStep * 0.1;
	}
}

void CUnequalIntervalScale::SetAngleToClipboard(void)
{
	if (adjustMode == ADJUST)
	{
		tstringstream ss;
		tstring str;
		ss << angle;
		ss >> str;
				
		clipboardOutput((TCHAR*)str.c_str());
	}
}
double CUnequalIntervalScale::ConvertValue(double x)
{
	switch (adjustMode)
	{
	case NORMAL:
		return linearInterpolate(x) + 180;
	case ADJUST:
		return angle + 180;
	case VERIFY:
		return linearInterpolate(adjustValue) + 180;
	case ROTATE:
		rotateAngle += rotateStep;
		return rotateAngle + 180;
	default:
		return 0;
	}
}

bool CUnequalIntervalScale::GetDeveloperModeSetting()
{
	return developerMode;
}

double CUnequalIntervalScale::linearInterpolate(double x)
{
	// p[^͗vf2̏ꍇ
	if (params.empty() || (int)params.size() < 2)
	{
		// `⊮s\Ȃ߃[Ԃ
		return 0;
	}

	// Ce[^
	map<double, double>::iterator prev;
	map<double, double>::iterator next;

	if (x < params.begin()->first) // ͒lp[^̍ŏX̏ꍇ
	{
		prev = params.begin(); // f[^擪
		next = prev++;
	}
	else if (x >= (--params.end())->first) // ͒lp[^̍őXȏ̏ꍇ
	{
		next = --params.end(); // f[^
		prev = next--;
	}
	else // X͈͓̔̏ꍇ
	{
		next = params.upper_bound(x); // x傫lŏ̗vf
		prev = next--;
	}

	// `
	return prev->second + (x - prev->first) * (next->second - prev->second) / (next->first - prev->first);
}

// *********************************************************
// http://win32cpp.seesaa.net/article/120567918.html
// Nbv{[hփeLXgRs[
// ߂l :  true, s false
// *********************************************************
BOOL CUnequalIntervalScale::clipboardOutput(TCHAR *szData)
{
	HGLOBAL hGlobal;
	LPTSTR pMem;

	hGlobal = GlobalAlloc(GHND, lstrlen(szData) + 128);
	if (hGlobal == NULL) {
		return FALSE;
	}
	pMem = (LPTSTR)GlobalLock(hGlobal);
	if (pMem == NULL) {
		GlobalFree(hGlobal);
		return FALSE;
	}
	lstrcpy(pMem, szData);
	GlobalUnlock(hGlobal);
	OpenClipboard(NULL);
	EmptyClipboard();
	SetClipboardData(CF_TEXT, hGlobal);
	CloseClipboard();

	return TRUE;
}