#include "stdafx.h"
#include "atsplugin.h"
#include "NeedleVibration.h"
#define _USE_MATH_DEFINES
#include <math.h>

CNeedleVibration::CNeedleVibration()
{
}

CNeedleVibration::~CNeedleVibration()
{
}

void CNeedleVibration::SetPeriod(double value)
{
	coefficient = value == 0 ? 0 : fabs((2 * M_PI) / ((10.0 * 1000 / 3600) * value));
}

void CNeedleVibration::SetAmplitude(double value)
{
	amplitude = fabs(value);
}

void CNeedleVibration::SetThreshold(double value)
{
	threshold = fabs(value);
}

void CNeedleVibration::SetParameters(double p, double a, double t)
{
	coefficient = p == 0 ? 0 : fabs((2 * M_PI) / ((10.0 * 1000 / 3600) * p));
	amplitude = fabs(a);
	threshold = fabs(t);
}

double CNeedleVibration::NeedleVibrationMain(double value, double location)
{
	// Up[^0Ȃ͒l̂܂ܕԂ
	if (amplitude == 0 || coefficient == 0)
	{
		return value;
	}

	// x̐Βl
	double speed = fabs(value);

	// xlȏȂjUȂ
	if (threshold != 0 && threshold < speed)
	{
		return speed;
	}
	else
	{
		// wjȖxo
		return speed + sin(location * coefficient)
			* (amplitude > speed ? speed : amplitude); // x0ߖT̏ꍇAU߂
	}
}