#pragma once

#include "Settings.h"
#include "SettingWindow.h"

using namespace System;
using namespace System::ComponentModel;
using namespace System::Collections;
using namespace System::Collections::Generic;
using namespace System::Windows::Forms;
using namespace System::Data;
using namespace System::Drawing;
using namespace Microsoft::VisualBasic::FileIO;
using namespace System::Reflection;

#define MAX_ARRAY 256

namespace Ats {

	/// <summary>
	/// InfoWindow ̊Tv
	///
	/// x: ̃NX̖OύXꍇÃNXˑ邷ׂĂ .resx t@CɊ֘Atꂽ
	///          }l[W \[X RpC c[ɑ΂ 'Resource File Name' vpeB
	///          ύXKv܂B̕ύXsȂƁA
	///          fUCiƁÃtH[Ɋ֘Atꂽ[JCYς݃\[XƂA
	///          ݂ɗpłȂȂ܂B
	/// </summary>
	public ref class InfoWindow : public System::Windows::Forms::Form
	{
	public:
		InfoWindow(void)
		{
			InitializeComponent();
			//
			//TODO: ɃRXgN^ R[hǉ܂
			//

			// Xg̕ێ
			prevListWidth = stateListView->Width;
			init();
		}

	protected:
		/// <summary>
		/// gp̃\[XׂăN[Abv܂B
		/// </summary>
		~InfoWindow()
		{
			if (components)
			{
				delete components;
			}
		}

	protected:

	private: System::Windows::Forms::ListView^  stateListView;
	private: System::Windows::Forms::ListView^  panelListView;
	private: System::Windows::Forms::ListView^  soundListView;
	private: System::Windows::Forms::Label^  panelLabel;
	private: System::Windows::Forms::Label^  soundLabel;



	private: System::Windows::Forms::CheckBox^  checkBox1;
	private: System::Windows::Forms::Button^  button1;
	private: System::Windows::Forms::ColorDialog^  colorDialog1;
	private: System::Windows::Forms::ColumnHeader^  columnHeader1;
	private: System::Windows::Forms::ColumnHeader^  columnHeader2;
	private: System::Windows::Forms::ColumnHeader^  columnHeader3;
	private: System::Windows::Forms::ColumnHeader^  columnHeader4;
	private: System::Windows::Forms::ColumnHeader^  columnHeader5;
	private: System::Windows::Forms::ColumnHeader^  columnHeader6;
	private: System::Windows::Forms::ColumnHeader^  columnHeader7;
	private: System::Windows::Forms::ColumnHeader^  columnHeader8;

	protected:

	private:
		/// <summary>
		/// KvȃfUCiϐłB
		/// </summary>
		System::ComponentModel::Container ^components;

#pragma region Windows Form Designer generated code
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		void InitializeComponent(void)
		{
			this->stateListView = (gcnew System::Windows::Forms::ListView());
			this->columnHeader1 = (gcnew System::Windows::Forms::ColumnHeader());
			this->columnHeader2 = (gcnew System::Windows::Forms::ColumnHeader());
			this->panelListView = (gcnew System::Windows::Forms::ListView());
			this->columnHeader3 = (gcnew System::Windows::Forms::ColumnHeader());
			this->columnHeader4 = (gcnew System::Windows::Forms::ColumnHeader());
			this->columnHeader5 = (gcnew System::Windows::Forms::ColumnHeader());
			this->soundListView = (gcnew System::Windows::Forms::ListView());
			this->columnHeader6 = (gcnew System::Windows::Forms::ColumnHeader());
			this->columnHeader7 = (gcnew System::Windows::Forms::ColumnHeader());
			this->columnHeader8 = (gcnew System::Windows::Forms::ColumnHeader());
			this->panelLabel = (gcnew System::Windows::Forms::Label());
			this->soundLabel = (gcnew System::Windows::Forms::Label());
			this->checkBox1 = (gcnew System::Windows::Forms::CheckBox());
			this->button1 = (gcnew System::Windows::Forms::Button());
			this->colorDialog1 = (gcnew System::Windows::Forms::ColorDialog());
			this->SuspendLayout();
			// 
			// stateListView
			// 
			this->stateListView->Anchor = static_cast<System::Windows::Forms::AnchorStyles>(((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Bottom)
				| System::Windows::Forms::AnchorStyles::Left));
			this->stateListView->Columns->AddRange(gcnew cli::array< System::Windows::Forms::ColumnHeader^  >(2) {
				this->columnHeader1,
					this->columnHeader2
			});
			this->stateListView->GridLines = true;
			this->stateListView->Location = System::Drawing::Point(12, 37);
			this->stateListView->Name = L"stateListView";
			this->stateListView->Size = System::Drawing::Size(196, 393);
			this->stateListView->TabIndex = 7;
			this->stateListView->UseCompatibleStateImageBehavior = false;
			this->stateListView->View = System::Windows::Forms::View::Details;
			// 
			// columnHeader1
			// 
			this->columnHeader1->Text = L"l̎";
			this->columnHeader1->Width = 100;
			// 
			// columnHeader2
			// 
			this->columnHeader2->Text = L"l";
			this->columnHeader2->Width = 70;
			// 
			// panelListView
			// 
			this->panelListView->Anchor = static_cast<System::Windows::Forms::AnchorStyles>(((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Bottom)
				| System::Windows::Forms::AnchorStyles::Left));
			this->panelListView->BackColor = System::Drawing::SystemColors::Window;
			this->panelListView->Columns->AddRange(gcnew cli::array< System::Windows::Forms::ColumnHeader^  >(3) {
				this->columnHeader3,
					this->columnHeader4, this->columnHeader5
			});
			this->panelListView->GridLines = true;
			this->panelListView->Location = System::Drawing::Point(214, 37);
			this->panelListView->Name = L"panelListView";
			this->panelListView->Size = System::Drawing::Size(196, 393);
			this->panelListView->TabIndex = 8;
			this->panelListView->UseCompatibleStateImageBehavior = false;
			this->panelListView->View = System::Windows::Forms::View::Details;
			// 
			// columnHeader3
			// 
			this->columnHeader3->Text = L"Index";
			this->columnHeader3->Width = 40;
			// 
			// columnHeader4
			// 
			this->columnHeader4->Text = L"l";
			this->columnHeader4->Width = 40;
			// 
			// columnHeader5
			// 
			this->columnHeader5->Text = L"";
			this->columnHeader5->Width = 90;
			// 
			// soundListView
			// 
			this->soundListView->Anchor = static_cast<System::Windows::Forms::AnchorStyles>(((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Bottom)
				| System::Windows::Forms::AnchorStyles::Left));
			this->soundListView->Columns->AddRange(gcnew cli::array< System::Windows::Forms::ColumnHeader^  >(3) {
				this->columnHeader6,
					this->columnHeader7, this->columnHeader8
			});
			this->soundListView->GridLines = true;
			this->soundListView->Location = System::Drawing::Point(416, 37);
			this->soundListView->Name = L"soundListView";
			this->soundListView->Size = System::Drawing::Size(196, 393);
			this->soundListView->TabIndex = 9;
			this->soundListView->UseCompatibleStateImageBehavior = false;
			this->soundListView->View = System::Windows::Forms::View::Details;
			// 
			// columnHeader6
			// 
			this->columnHeader6->Text = L"Index";
			this->columnHeader6->Width = 40;
			// 
			// columnHeader7
			// 
			this->columnHeader7->Text = L"l";
			this->columnHeader7->Width = 40;
			// 
			// columnHeader8
			// 
			this->columnHeader8->Text = L"";
			this->columnHeader8->Width = 90;
			// 
			// panelLabel
			// 
			this->panelLabel->AutoSize = true;
			this->panelLabel->Location = System::Drawing::Point(212, 14);
			this->panelLabel->Name = L"panelLabel";
			this->panelLabel->Size = System::Drawing::Size(33, 12);
			this->panelLabel->TabIndex = 3;
			this->panelLabel->Text = L"Panel";
			// 
			// soundLabel
			// 
			this->soundLabel->AutoSize = true;
			this->soundLabel->Location = System::Drawing::Point(414, 14);
			this->soundLabel->Name = L"soundLabel";
			this->soundLabel->Size = System::Drawing::Size(36, 12);
			this->soundLabel->TabIndex = 5;
			this->soundLabel->Text = L"Sound";
			// 
			// checkBox1
			// 
			this->checkBox1->AutoSize = true;
			this->checkBox1->Location = System::Drawing::Point(122, 13);
			this->checkBox1->Name = L"checkBox1";
			this->checkBox1->Size = System::Drawing::Size(60, 16);
			this->checkBox1->TabIndex = 6;
			this->checkBox1->Text = L"őO";
			this->checkBox1->UseVisualStyleBackColor = true;
			this->checkBox1->CheckedChanged += gcnew System::EventHandler(this, &InfoWindow::checkBox1_CheckedChanged);
			// 
			// button1
			// 
			this->button1->Location = System::Drawing::Point(12, 9);
			this->button1->Name = L"button1";
			this->button1->Size = System::Drawing::Size(75, 23);
			this->button1->TabIndex = 4;
			this->button1->Text = L"ݒ";
			this->button1->UseVisualStyleBackColor = true;
			this->button1->Click += gcnew System::EventHandler(this, &InfoWindow::button1_Click);
			// 
			// colorDialog1
			// 
			this->colorDialog1->AnyColor = true;
			this->colorDialog1->FullOpen = true;
			// 
			// InfoWindow
			// 
			this->AutoScaleDimensions = System::Drawing::SizeF(6, 12);
			this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
			this->ClientSize = System::Drawing::Size(624, 442);
			this->Controls->Add(this->button1);
			this->Controls->Add(this->checkBox1);
			this->Controls->Add(this->soundLabel);
			this->Controls->Add(this->panelLabel);
			this->Controls->Add(this->soundListView);
			this->Controls->Add(this->panelListView);
			this->Controls->Add(this->stateListView);
			this->DoubleBuffered = true;
			this->MinimumSize = System::Drawing::Size(640, 480);
			this->Name = L"InfoWindow";
			this->ShowIcon = false;
			this->Text = L"Bvets Status Window";
			this->FormClosing += gcnew System::Windows::Forms::FormClosingEventHandler(this, &InfoWindow::InfoWindow_FormClosing);
			this->SizeChanged += gcnew System::EventHandler(this, &InfoWindow::InfoWindow_SizeChanged);
			this->ResumeLayout(false);
			this->PerformLayout();

		}
#pragma endregion

	public:
		void Initialize(void); // JEgiԑk΍j
		void Elapse(ATS_VEHICLESTATE *, int *, int *, ATS_HANDLES *); // t[Ƃ̏
		void SetStateValue(String^, String^);  // ԃXgr[̐lXVinCCgj
		void SaveSettings(void); // ݒ̕ۑ
		String^ GetPowerLabel(int); // ͍smb`x̎擾
		String^ GetBrakeLabel(int); // u[Lnhx̎擾
		String^ GetReverserLabel(int); // o[Tx̎擾
		String^ GetSignalLabel(int); // Mx̎擾
		String^ GetBeaconLabel(int); // nqރx̎擾
		String^ GetKeyLabel(int); // L[̓x̎擾
		String^ GetHornLabel(int); // xJx̎擾
		String^ GetDoorLabel(bool); // pCbgvx̎擾

	private:
		CSettings^ settings; // AvP[Vݒi[NX
		Ats::SettingWindow^ s; // ݒEBhENX

		String^ dllPath; // DLLpX
		String^ dllDir; // DLLfBNg
		String^ iniPath; // INIt@CpX
		String^ settingPath; // AvP[VݒpX

		int refleshCount; // ԐlXg̍XVJEgpϐ

		double prevLocation; // OԐlXgXV̋[m]
		float prevSpeed; // OԐlXgXV̑x[km/h]
		int prevTime; // OԐlXgXV̎[msec]
		int prevListWidth;

		Color highLightColor; // Xg̐lXV̋F
		int highLightTime; // Xg̐lXV̔wiFύXp[msec]

		array<int>^ prevPanelValue; // Ot[Panelݒ͒l
		array<int>^ prevSoundValue; // Ot[Soundݒ͒l

		array<unsigned long>^ timerStateValue; // wiFXVp^C}[iԁj
		array<unsigned long>^ timerPanelValue; // wiFXVp^C}[iplj
		array<unsigned long>^ timerSoundValue; // wiFXVp^C}[iTEhj

		Dictionary<int, String^>^ signalLabel; // MCfbNXx
		Dictionary<int, String^>^ beaconLabel; // nqCfbNXx
		Dictionary<int, String^>^ powerLabel; // ͍smb`CfbNXx
		Dictionary<int, String^>^ brakeLabel; // u[LnhCfbNXx
		Dictionary<int, String^>^ reverserLabel; // o[TCfbNXx
		Dictionary<String^, String^>^ keyLabel; // L[CfbNXx
		Dictionary<String^, String^>^ hornLabel; // xJCfbNXx
		Dictionary<int, String^>^ keyAssign; // L[ATC
		Dictionary<int, String^>^ hornAssign; // xJATC

		Dictionary<String^, int>^ stateIndex; // 鐔lɑΉԃXgr[̃CfbNXi[
		List<KeyValuePair<int, int>>^ panelIndex; // 鐔lɑΉplXgr[̃CfbNXi[
		List<KeyValuePair<int, int>>^ soundIndex; // 鐔lɑΉTEhXgr[̃CfbNXi[

		Dictionary<String^, String^>^ stringFormat; // l̕ϊݒi[

		int tickCount; // oߎԌvpJEg

		void init(void); // 
		void enableDoubleBuffering(Control^ control); // _uobt@O̗Lih~j
		void setStateListViewItem(String^); // xXgr[փZbg
		List<KeyValuePair<int, int>>^ setListViewItem(ListView^, int, String^); // xXgr[փZbg
		Dictionary<int, String^>^ loadLabels(String^); // x̓ǂݍ
		Dictionary<String^, String^>^ loadKeyHornLabels(String^); // x̓ǂݍ
		TextFieldParser^ getParser(String^); // TextFieldParser̎擾
		String^ getStringFromIni(String^, String^, String^, String^); // ini`ݒ̓ǂݎ
		int setStateValueNoHighLight(String^, String^); // ԃXgr[̐lXVinCCgȂj
		void setStateValueWithFormat(String^, double); // ԃXgr[̐lXVinCCgȂj
		void updateListView(ListView^, int*, array<int>^, array<unsigned long>^, List<KeyValuePair<int, int>>^); // PanelESound\XV
		void updateHighlight(ListView^, array<unsigned long>^); // nCCg\̍XV
		String^ getLabelFromDictionary(Dictionary<int, String^>^, int); // xeLXgDictionary擾
		String^ getLabelFromDictionary(Dictionary<String^, String^>^, int, Dictionary<int, String^>^); // xeLXgDictionary擾iL[ExJj
		void loadSettings(void); // ݒ̓ǂݍ
		void resetCount(System::Object^, System::EventArgs^); // JEg̃ZbgiCxgo^pj

	private: System::Void checkBox1_CheckedChanged(System::Object^  sender, System::EventArgs^  e) {
		this->TopMost = checkBox1->Checked;
	}
	private: System::Void InfoWindow_Shown(System::Object^  sender, System::ComponentModel::CancelEventArgs^ e) {
	}
	private: System::Void InfoWindow_FormClosing(System::Object^  sender, System::Windows::Forms::FormClosingEventArgs^  e) {
		// ݒ̕ۑ
		SaveSettings();

		// EBhE\
		e->Cancel = true;
		this->Hide();
	}
	private: System::Void button1_Click(System::Object^  sender, System::EventArgs^  e) {
		// ݒEBhE\Ȃ\
		if (!s->Visible)
		{
			s->Show(this);
		}
	}
	private: System::Void InfoWindow_SizeChanged(System::Object^  sender, System::EventArgs^  e) {
		int width = (this->Width - 52) / 3;

		Point point;
		point.Y = stateListView->Location.Y;

		point.X = 12;
		stateListView->Location = point;
		point.X = 18 + width;
		panelListView->Location = point;
		point.X = 24 + width * 2;
		soundListView->Location = point;

		point.Y = panelLabel->Location.Y;
		point.X = 18 + width - 2;
		panelLabel->Location = point;
		point.X = 24 + width * 2 - 2;
		soundLabel->Location = point;

		stateListView->Width = width;
		panelListView->Width = width;
		soundListView->Width = width;

		stateListView->Columns[0]->Width = stateListView->Columns[0]->Width * width / prevListWidth;
		stateListView->Columns[1]->Width = stateListView->Columns[1]->Width * width / prevListWidth;

		panelListView->Columns[0]->Width = panelListView->Columns[0]->Width * width / prevListWidth;
		panelListView->Columns[1]->Width = panelListView->Columns[1]->Width * width / prevListWidth;
		panelListView->Columns[2]->Width = panelListView->Columns[2]->Width * width / prevListWidth;

		soundListView->Columns[0]->Width = soundListView->Columns[0]->Width * width / prevListWidth;
		soundListView->Columns[1]->Width = soundListView->Columns[1]->Width * width / prevListWidth;
		soundListView->Columns[2]->Width = soundListView->Columns[2]->Width * width / prevListWidth;

		prevListWidth = width;
	}
	};
}
