#include <Windows.h>
//#include <climits>
//#include <memory>
#include "atsplugin.h"
#include "InfoWindow.h"

using namespace System::IO;
using namespace System::Reflection;
using namespace System::Runtime::InteropServices;

void Ats::InfoWindow::init(void)
{
	// pXݒ
	dllPath = System::Reflection::Assembly::GetExecutingAssembly()->Location;
	dllDir = Path::GetDirectoryName(dllPath);
	iniPath = Path::GetDirectoryName(dllPath) + Path::DirectorySeparatorChar + Path::GetFileNameWithoutExtension(dllPath) + ".ini";
	settingPath = dllDir + Path::DirectorySeparatorChar + "BvetsStatusWindow.Settings.xml";	

	// ݒEBhENX̃CX^XƐݒǂݍ
	s = gcnew Ats::SettingWindow();
	loadSettings();

	int maxArrayLength = settings->MaxArrayIndex + 1;
	if (maxArrayLength < 0)
	{
		maxArrayLength = 0;
	}

	// _uobt@O̗L
	enableDoubleBuffering(stateListView);
	enableDoubleBuffering(panelListView);
	enableDoubleBuffering(soundListView);

	// ԐlXg̍so^
	setStateListViewItem("StateLabel");

	// plETEh̐lXg̍so^
	panelIndex = setListViewItem(panelListView, maxArrayLength, "PanelLabel");
	soundIndex = setListViewItem(soundListView, maxArrayLength, "SoundLabel");

	// xǂݍ
	powerLabel = loadLabels("PowerLabel");
	brakeLabel = loadLabels("BrakeLabel");
	reverserLabel = loadLabels("ReverserLabel");
	signalLabel = loadLabels("SignalLabel");
	beaconLabel = loadLabels("BeaconLabel");
	keyLabel = loadKeyHornLabels("KeyLabel");
	hornLabel = loadKeyHornLabels("HornLabel");

	// el̍XVp̒Olێz̏
	prevPanelValue = gcnew array<int>(maxArrayLength);
	prevSoundValue = gcnew array<int>(maxArrayLength);

	// wiFXVp^C}[z̏
	timerStateValue = gcnew array<unsigned long>(MAX_ARRAY);
	timerPanelValue = gcnew array<unsigned long>(maxArrayLength);
	timerSoundValue = gcnew array<unsigned long>(maxArrayLength);

	for (int i = 0; i < MAX_ARRAY; i++)
	{
		timerStateValue[i] = ULONG_MAX;
	}
	for (int i = 0; i < maxArrayLength; i++)
	{
		timerPanelValue[i] = ULONG_MAX;
		timerSoundValue[i] = ULONG_MAX;
	}

	// AvP[Vݒ̓Kp
	checkBox1->Checked = settings->Topmost;

	stateListView->Columns[0]->Width = settings->StateIndexWidth;
	stateListView->Columns[1]->Width = settings->StateValueWidth;

	panelListView->Columns[0]->Width = settings->PanelIndexWidth;
	panelListView->Columns[1]->Width = settings->PanelValueWidth;
	panelListView->Columns[2]->Width = settings->PanelLabelWidth;

	soundListView->Columns[0]->Width = settings->SoundIndexWidth;
	soundListView->Columns[1]->Width = settings->SoundValueWidth;
	soundListView->Columns[2]->Width = settings->SoundLabelWidth;

	this->Width = settings->MainWindowWidth;
	this->Height = settings->MainWindowHeight;

	// L[ExJATC̏ݒ
	keyAssign = gcnew Dictionary<int, String^>();
	keyAssign[ATS_KEY_S] = "S";
	keyAssign[ATS_KEY_A1] = "A1";
	keyAssign[ATS_KEY_A2] = "A2";
	keyAssign[ATS_KEY_B1] = "B1";
	keyAssign[ATS_KEY_B2] = "B2";
	keyAssign[ATS_KEY_C1] = "C1";
	keyAssign[ATS_KEY_C2] = "C2";
	keyAssign[ATS_KEY_D] = "D";
	keyAssign[ATS_KEY_E] = "E";
	keyAssign[ATS_KEY_F] = "F";
	keyAssign[ATS_KEY_G] = "G";
	keyAssign[ATS_KEY_H] = "H";
	keyAssign[ATS_KEY_I] = "I";
	keyAssign[ATS_KEY_J] = "J";
	keyAssign[ATS_KEY_K] = "K";
	keyAssign[ATS_KEY_L] = "L";

	hornAssign = gcnew Dictionary<int, String^>();
	hornAssign[ATS_HORN_PRIMARY] = "HORN1";
	hornAssign[ATS_HORN_SECONDARY] = "HORN2";
	hornAssign[ATS_HORN_MUSIC] = "MUSIC";
}

void Ats::InfoWindow::enableDoubleBuffering(Control^ control)
{
	array<Object^>^ arr = { true };

	control->GetType()->InvokeMember("DoubleBuffered",
		BindingFlags::NonPublic | BindingFlags::Instance | BindingFlags::SetProperty,
		nullptr, control, arr);
}

void Ats::InfoWindow::setStateListViewItem(String^ key)
{
	stateIndex = gcnew Dictionary<String^, int>();
	stringFormat = gcnew Dictionary<String^, String^>();

	array<String^>^ formattingEnabledLabel =
		gcnew array < String^ >{ "LOCATION", "SPEED", "BC", "MR", "ER", "BP", "SAP", "CURRENT", "ACCELERATION", "BEACON_DISTANCE", "FRAMERATE" };
	for each(String^ s in formattingEnabledLabel){ stringFormat[s] = "0.###"; }

	try
	{
		TextFieldParser^ parser;

		try
		{
			parser = getParser(key);
		}
		catch (Exception^ e)
		{
			// t@Cǂݍ߂ȂꍇftHgݒ\[X擾
			Reflection::Assembly^ thisDll = Reflection::Assembly::GetExecutingAssembly();
			Resources::ResourceManager^ resources = gcnew Resources::ResourceManager("Ats.InfoWindow", thisDll);
			String^ s = resources->GetString("DefaultStateLabel");
			IO::MemoryStream^ stream = gcnew IO::MemoryStream(System::Text::Encoding::UTF8->GetBytes(s));

			parser = gcnew TextFieldParser(stream);
			parser->TextFieldType = FieldType::Delimited;
			parser->SetDelimiters(",");
		}

		int cnt = 0;

		while (!parser->EndOfData)
		{
			array<String^>^ row = parser->ReadFields();

			try
			{
				// Xgr[̍so^
				ListViewItem^ item = gcnew ListViewItem();
				item->Text = row[1]; // zvfOŗO
				item->SubItems->Add("");

				// Xgr[̃CfbNXL[Dictionaryɓo^
				stateIndex[row[0]->ToUpper()] = cnt; // L[dŏ㏑

				// lϊtH[}bg̓o^
				if (stringFormat->ContainsKey(row[0]->ToUpper()))
				{
					try
					{
						String^ str = (0.0).ToString(row[2]);
						stringFormat[row[0]->ToUpper()] = row[2];
					}
					catch (Exception^ e) { stringFormat[row[0]->ToUpper()] = "0.###"; }
				}

				stateListView->Items->Add(item);
				cnt++;
			}
			catch (Exception^ e) {}
		}
	}
	catch (Exception^ e) {}
}

List<KeyValuePair<int, int>>^ Ats::InfoWindow::setListViewItem(ListView^ lv, int maxArray, String^ key)
{
	List<KeyValuePair<int, int>>^ keyValue = gcnew List<KeyValuePair<int, int>>();

	try
	{
		TextFieldParser^ parser;

		try
		{
			parser = getParser(key);
		}
		catch (Exception^ e)
		{
			// t@Cǂݍ߂ȂꍇSĂ̐l\
			String^ s;
			int length = maxArray < MAX_ARRAY ? maxArray : MAX_ARRAY;
			for (int i = 0; i < length; i++)	{ s += i.ToString() + "\r\n"; }
			IO::MemoryStream^ stream = gcnew IO::MemoryStream(System::Text::Encoding::UTF8->GetBytes(s));

			parser = gcnew TextFieldParser(stream);
			parser->TextFieldType = FieldType::Delimited;
			parser->SetDelimiters(",");
		}

		while (!parser->EndOfData)
		{
			try
			{
				array<String^>^ row = parser->ReadFields();

				if (row->Length == 1 && row[0] == "")
				{
					ListViewItem^ item = gcnew ListViewItem();
					lv->Items->Add(item);
					continue;
				}

				int key = int::Parse(row[0]);

				if (key >= 0 && key < maxArray)
				{
					ListViewItem^ item = gcnew ListViewItem();
					item->Text = key.ToString();
					item->SubItems->Add("0");
					try
					{
						item->SubItems->Add(row[1]);
					}
					catch (Exception^ e)
					{
						item->SubItems->Add("");
					}
					lv->Items->Add(item);

					KeyValuePair<int, int> pair = KeyValuePair<int, int>(key, lv->Items->Count - 1);
					keyValue->Add(pair);
				}
			}
			catch (Exception^ e) {}
		}
	}
	catch (Exception^ e) {}

	return keyValue;
}

Dictionary<int, String^>^ Ats::InfoWindow::loadLabels(String^ key)
{
	Dictionary<int, String^>^ dic = gcnew Dictionary<int, String^>();

	try
	{
		TextFieldParser^ parser = getParser(key);

		while (!parser->EndOfData)
		{
			try
			{
				array<String^>^ row = parser->ReadFields();
				dic->Add(int::Parse(row[0]->ToUpper()), row[1]);
			}
			catch (Exception^ e) {}
		}
	}
	catch (Exception^ e) {}

	return dic;
}

Dictionary<String^, String^>^ Ats::InfoWindow::loadKeyHornLabels(String^ key)
{
	Dictionary<String^, String^>^ dic = gcnew Dictionary<String^, String^>();

	try
	{
		TextFieldParser^ parser = getParser(key);

		while (!parser->EndOfData)
		{
			try
			{
				array<String^>^ row = parser->ReadFields();
				dic->Add(row[0], row[1]);
			}
			catch (Exception^ e) {}
		}
	}
	catch (Exception^ e) {}

	return dic;
}

TextFieldParser^ Ats::InfoWindow::getParser(String^ key)
{
	TextFieldParser^ parser;

	try
	{
		String^ fileName = getStringFromIni("FileName", key, key + ".csv", iniPath);
		parser = gcnew TextFieldParser(dllDir + Path::DirectorySeparatorChar + fileName, System::Text::Encoding::GetEncoding("Shift_JIS"));
		parser->TextFieldType = FieldType::Delimited;
		if (Path::GetExtension(fileName) == ".csv") parser->SetDelimiters(",");
		else parser->SetDelimiters("\t");
	}
	catch (Exception^ e) { throw; }

	return parser;
}

String^ Ats::InfoWindow::getStringFromIni(String^ section, String^ key, String^ defaultValue, String^ path)
{
	TCHAR valueChar[4096];

	// String -> const TCHAR*
	IntPtr setcionPtr = Marshal::StringToHGlobalAuto(section);
	IntPtr keyPtr = Marshal::StringToHGlobalAuto(key);
	IntPtr defaultPtr = Marshal::StringToHGlobalAuto(defaultValue);
	IntPtr pathPtr = Marshal::StringToHGlobalAuto(path);

	const TCHAR* sectionChar = static_cast<const TCHAR*>(setcionPtr.ToPointer());
	const TCHAR* keyChar = static_cast<const TCHAR*>(keyPtr.ToPointer());
	const TCHAR* defaultChar = static_cast<const TCHAR*>(defaultPtr.ToPointer());
	const TCHAR* pathChar = static_cast<const TCHAR*>(pathPtr.ToPointer());

	GetPrivateProfileString(sectionChar, keyChar, defaultChar, valueChar, sizeof(valueChar), pathChar);

	Marshal::FreeHGlobal(setcionPtr);
	Marshal::FreeHGlobal(keyPtr);
	Marshal::FreeHGlobal(defaultPtr);
	Marshal::FreeHGlobal(pathPtr);

	// const TCHAR* -> String
	return gcnew String(valueChar);
}

void Ats::InfoWindow::Initialize(void)
{
	// ԂkwWvp̃JEg
	refleshCount = -1;

	// oߎԎ擾
	tickCount = GetTickCount();
}

void Ats::InfoWindow::Elapse(ATS_VEHICLESTATE *state, int *panel, int *sound, ATS_HANDLES *output)
{
	// XVԊu[msec]
	int interval;

	// XVԊu0ȊO̒lݒ
	if (settings->RefleshInterval != 0) { interval = settings->RefleshInterval; }
	else { interval = 1; }

	// oߎԎ擾
	tickCount = GetTickCount();

	// ListView̍XVJniׁj
	//stateListView->BeginUpdate();
	//panelListView->BeginUpdate();
	//soundListView->BeginUpdate();

	// ԗԍXV
	if (refleshCount < state->Time / settings->RefleshInterval)
	{
		refleshCount = state->Time / settings->RefleshInterval;

		// xEt[[g
		float acceleration = 0;
		double frameRate = 0;
		if (state->Time - prevTime != 0)
		{
			acceleration = (state->Speed - prevSpeed) / (state->Time - prevTime) * 1000;
			frameRate = 1000 / (state->Time - prevTime);
		}

		// 
		String^ time = "";
		time = (state->Time / (1000 * 60 * 60)).ToString("00") + ":"
			+ (state->Time / (1000 * 60) % 60).ToString("00") + ":"
			+ (state->Time / 1000 % 60).ToString("00") + "."
			+ (state->Time % 1000).ToString("000");

		// Xgr[̍XV
		setStateValueWithFormat("LOCATION", state->Location);
		setStateValueWithFormat("SPEED", state->Speed);
		setStateValueNoHighLight("TIME", state->Time.ToString());
		setStateValueNoHighLight("TIME_HHMMSS", time);
		setStateValueWithFormat("BC", state->BcPressure);
		setStateValueWithFormat("MR", state->MrPressure);
		setStateValueWithFormat("ER", state->ErPressure);
		setStateValueWithFormat("BP", state->BpPressure);
		setStateValueWithFormat("SAP", state->SapPressure);
		setStateValueWithFormat("CURRENT", state->Current);
		setStateValueWithFormat("ACCELERATION", acceleration);
		setStateValueWithFormat("FRAMERATE", frameRate);

		// xEt[[gvẐߑOXV̋ExEԂێ
		prevLocation = state->Location;
		prevSpeed = state->Speed;
		prevTime = state->Time;
	}

	// Ԑl̃Xg̔wiFXV
	updateHighlight(stateListView, timerStateValue);

	// Panel̐lXgXV
	updateListView(panelListView, panel, prevPanelValue, timerPanelValue, panelIndex);

	// Sound̐lXgXV
	updateListView(soundListView, sound, prevSoundValue, timerSoundValue, soundIndex);

	// ListView̍XVIiׁj
	//stateListView->EndUpdate();
	//panelListView->EndUpdate();
	//soundListView->EndUpdate();

	// EBhEANeBułRg[\XV
	this->Update();
}

void Ats::InfoWindow::SetStateValue(String^ key, String^ value)
{
	int index = setStateValueNoHighLight(key, value);

	if (index == -1) { return; }

	// nCCgݒ
	timerStateValue[index] = tickCount + settings->HighLightTime;
	stateListView->Items[index]->SubItems[0]->BackColor = settings->HighLightColor;
}

int Ats::InfoWindow::setStateValueNoHighLight(String^ key, String^ value)
{
	if (!this->Visible) { return -1; }

	int index;

	// L[݂Ȃꍇ͏Ȃ
	if (!stateIndex->TryGetValue(key, index)) { return -1; }

	// ListView̐lXV
	stateListView->Items[index]->SubItems[1]->Text = value;

	return index;
}

void Ats::InfoWindow::setStateValueWithFormat(String^ key, double value)
{
	if (!this->Visible) { return; }

	int index;

	// L[݂Ȃꍇ͏Ȃ
	if (!stateIndex->TryGetValue(key, index)) { return; }

	// ListView̐lXV
	String^ text = value.ToString(stringFormat[key]);
	if (stateListView->Items[index]->SubItems[1]->Text != text)
	{
		stateListView->Items[index]->SubItems[1]->Text = text;
	}
}

void Ats::InfoWindow::updateListView(ListView^ lv, int *value, array<int>^ prevValue, array<unsigned long>^ timerValue, List<KeyValuePair<int, int>>^ keyValue)
{
	for (int i = 0; i < keyValue->Count; i++)
	{
		KeyValuePair<int, int> pair = keyValue[i];

		try
		{
			// l̍XVƔwiFύX
			if (prevValue[pair.Key] != value[pair.Key])
			{
				lv->Items[pair.Value]->SubItems[1]->Text = value[pair.Key].ToString();
				prevValue[pair.Key] = value[pair.Key];

				timerValue[pair.Key] = tickCount + settings->HighLightTime;
				lv->Items[pair.Value]->SubItems[0]->BackColor = settings->HighLightColor;
			}

			// wiF̕
			if (timerValue[pair.Key] < tickCount)
			{
				timerValue[pair.Key] = ULONG_MAX; // \傫lɐݒ肵XVLZ
				lv->Items[pair.Value]->SubItems[0]->BackColor = System::Drawing::SystemColors::Window;
			}
		}
		catch (Exception^ e) {}
	}
}

void Ats::InfoWindow::updateHighlight(ListView^ lv, array<unsigned long>^ timerValue)
{
	for (int i = 0; i < lv->Items->Count; i++)
	{
		// wiF̕
		if (timerValue[i] < tickCount)
		{
			timerValue[i] = ULONG_MAX; // \傫lɐݒ肵XVLZ

			lv->Items[i]->SubItems[0]->BackColor = System::Drawing::SystemColors::Window;
		}
	}
}

#pragma region GetLabelMethods
String^ Ats::InfoWindow::getLabelFromDictionary(Dictionary<int, String^>^ dic, int index)
{
	if (!dic->ContainsKey(index)) { return index.ToString(); }
	else { return index.ToString() + " - " + dic[index]; }
}

String^ Ats::InfoWindow::getLabelFromDictionary(Dictionary<String^, String^>^ dic, int index, Dictionary<int, String^>^ assign)
{
	if (!dic->ContainsKey(assign[index])) { return assign[index]; }
	else if (dic[assign[index]] == "") { return assign[index]; }
	else { return assign[index] + " - " + dic[assign[index]]; }
}

String^ Ats::InfoWindow::GetPowerLabel(int index)
{
	return getLabelFromDictionary(powerLabel, index);
}

String^ Ats::InfoWindow::GetBrakeLabel(int index)
{
	return getLabelFromDictionary(brakeLabel, index);
}

String^ Ats::InfoWindow::GetReverserLabel(int index)
{
	return getLabelFromDictionary(reverserLabel, index);
}

String^ Ats::InfoWindow::GetSignalLabel(int index)
{
	return getLabelFromDictionary(signalLabel, index);
}

String^ Ats::InfoWindow::GetBeaconLabel(int index)
{
	return getLabelFromDictionary(beaconLabel, index);
}

String^ Ats::InfoWindow::GetKeyLabel(int index)
{
	return getLabelFromDictionary(keyLabel, index, keyAssign);
}

String^ Ats::InfoWindow::GetHornLabel(int index)
{
	return getLabelFromDictionary(hornLabel, index, hornAssign);
}

String^ Ats::InfoWindow::GetDoorLabel(bool index)
{
	if (index) { return ""; }
	else { return "J"; }
}
#pragma endregion

void Ats::InfoWindow::loadSettings(void)
{
	String^ loadPath;

	// ݊ێ
	if (!File::Exists(settingPath))
	{
		loadPath = dllDir + Path::DirectorySeparatorChar + "Settings.xml"; // Ver1.0
	}
	else
	{
		loadPath = settingPath; // Ver1.1-
	}

	try
	{
		System::Xml::Serialization::XmlSerializer^ serializer =
			gcnew System::Xml::Serialization::XmlSerializer(CSettings::typeid);

		System::IO::StreamReader^ sr =
			gcnew System::IO::StreamReader(loadPath, gcnew System::Text::UTF8Encoding(false));

		settings = safe_cast<CSettings^>(serializer->Deserialize(sr));
		sr->Close();
	}
	catch (Exception^ e) {}

	// ݒ肪ǂݍ܂ĂȂꍇ
	if (settings == nullptr)
	{
		settings = gcnew CSettings();
	}

	// Fݒ̓ǂݍݕϊ(J[R[h -> Color)
	settings->HighLightColor = ColorTranslator::FromHtml(settings->HighLightColorString);

	// ݒIuWFNgݒʃIuWFNg
	s->SetSettings(settings);

	// Cxg̓o^
	s->ResetCount += gcnew EventHandler(this, &InfoWindow::resetCount);
}

void Ats::InfoWindow::SaveSettings(void)
{
	// eݒ̕ۑ
	try
	{
		// ColorJ[R[hɕϊ
		settings->HighLightColorString = ColorTranslator::ToHtml(settings->HighLightColor);

		settings->RefleshInterval;
		settings->HighLightTime;
		settings->Topmost = checkBox1->Checked;

		settings->StateIndexWidth = stateListView->Columns[0]->Width;
		settings->StateValueWidth = stateListView->Columns[1]->Width;

		settings->PanelIndexWidth = panelListView->Columns[0]->Width;
		settings->PanelValueWidth = panelListView->Columns[1]->Width;
		settings->PanelLabelWidth = panelListView->Columns[2]->Width;

		settings->SoundIndexWidth = soundListView->Columns[0]->Width;
		settings->SoundValueWidth = soundListView->Columns[1]->Width;
		settings->SoundLabelWidth = soundListView->Columns[2]->Width;

		settings->MainWindowWidth = this->Width;
		settings->MainWindowHeight = this->Height;
		
		System::Xml::Serialization::XmlSerializer^ serializer =
			gcnew System::Xml::Serialization::XmlSerializer(CSettings::typeid);

		System::IO::StreamWriter^ sw =
			gcnew System::IO::StreamWriter(settingPath, false, gcnew System::Text::UTF8Encoding(false));

		serializer->Serialize(sw, settings);
		sw->Close();
	}
	catch (Exception^ e) {}
}

void Ats::InfoWindow::resetCount(System::Object^ sender, System::EventArgs^ e)
{
	refleshCount = -1;
}