#include <Windows.h>
#include "atsplugin.h"
#include "InfoWindow.h"
#include "Ats.h"

ATS_API void WINAPI Load()
{
	GlobalInstance::infoWindow = gcnew Ats::InfoWindow();
	
	// EBhE\
	GlobalInstance::infoWindow->Show();
}

ATS_API void WINAPI Dispose()
{
	// EBhẼCX^Xj
	if (GlobalInstance::infoWindow != nullptr)
	{
		GlobalInstance::infoWindow->SaveSettings();
		delete GlobalInstance::infoWindow;
	}
}

ATS_API int WINAPI GetPluginVersion()
{
	return ATS_VERSION;
}

ATS_API void WINAPI SetVehicleSpec(ATS_VEHICLESPEC vehicleSpec)
{
	GlobalInstance::infoWindow->SetStateValue("SPEC_POWER", vehicleSpec.PowerNotches.ToString());
	GlobalInstance::infoWindow->SetStateValue("SPEC_BRAKE", vehicleSpec.BrakeNotches.ToString());
	GlobalInstance::infoWindow->SetStateValue("SPEC_ATSNOTCH", vehicleSpec.AtsNotch.ToString());
	GlobalInstance::infoWindow->SetStateValue("SPEC_B67NOTCH", vehicleSpec.B67Notch.ToString());
	GlobalInstance::infoWindow->SetStateValue("SPEC_CARS", vehicleSpec.Cars.ToString());
}

ATS_API void WINAPI Initialize(int brake)
{
	GlobalInstance::infoWindow->Initialize();
}

ATS_API ATS_HANDLES WINAPI Elapse(ATS_VEHICLESTATE vehicleState, int *panel, int *sound)
{
	// nho
	g_output.Reverser = g_reverser;
	g_output.Power = g_powerNotch;
	g_output.Brake = g_brakeNotch;
	g_output.ConstantSpeed = ATS_CONSTANTSPEED_CONTINUE;

	//// EBhE\̂ݍXV
	if (GlobalInstance::infoWindow->Visible)
	{
		GlobalInstance::infoWindow->Elapse(&vehicleState, panel, sound, &g_output);
	}

	return g_output;
}

ATS_API void WINAPI SetPower(int notch)
{
	g_powerNotch = notch;
	GlobalInstance::infoWindow->SetStateValue("POWER", GlobalInstance::infoWindow->GetPowerLabel(notch));
}

ATS_API void WINAPI SetBrake(int notch)
{
	g_brakeNotch = notch;
	GlobalInstance::infoWindow->SetStateValue("BRAKE", GlobalInstance::infoWindow->GetBrakeLabel(notch));
}

ATS_API void WINAPI SetReverser(int pos)
{
	g_reverser = pos;
	GlobalInstance::infoWindow->SetStateValue("REVERSER", GlobalInstance::infoWindow->GetReverserLabel(pos));
}

ATS_API void WINAPI KeyDown(int atsKeyCode)
{
	GlobalInstance::infoWindow->SetStateValue("KEY_DOWN", GlobalInstance::infoWindow->GetKeyLabel(atsKeyCode));
}

ATS_API void WINAPI KeyUp(int atsKeyCode)
{
	GlobalInstance::infoWindow->SetStateValue("KEY_UP", GlobalInstance::infoWindow->GetKeyLabel(atsKeyCode));
}

ATS_API void WINAPI HornBlow(int atsHornBlowIndex)
{
	GlobalInstance::infoWindow->SetStateValue("HORN_BLOW", GlobalInstance::infoWindow->GetHornLabel(atsHornBlowIndex));
}

ATS_API void WINAPI DoorOpen()
{
	GlobalInstance::infoWindow->SetStateValue("DOOR", GlobalInstance::infoWindow->GetDoorLabel(false));
}

ATS_API void WINAPI DoorClose()
{
	GlobalInstance::infoWindow->SetStateValue("DOOR", GlobalInstance::infoWindow->GetDoorLabel(true));
}

ATS_API void WINAPI SetSignal(int signal)
{
	GlobalInstance::infoWindow->SetStateValue("SIGNAL", GlobalInstance::infoWindow->GetSignalLabel(signal));
}

ATS_API void WINAPI SetBeaconData(ATS_BEACONDATA beaconData)
{
	GlobalInstance::infoWindow->SetStateValue("BEACON_TYPE", GlobalInstance::infoWindow->GetBeaconLabel(beaconData.Type));
	GlobalInstance::infoWindow->SetStateValue("BEACON_SIGNAL", GlobalInstance::infoWindow->GetSignalLabel(beaconData.Signal));
	GlobalInstance::infoWindow->SetStateValue("BEACON_DISTANCE", beaconData.Distance.ToString("0.###"));
	GlobalInstance::infoWindow->SetStateValue("BEACON_OPTIONAL", beaconData.Optional.ToString());
}