#include "StdAfx.h"
#include <tchar.h>
#include <fstream>
#include <iomanip>
#include <algorithm>
#include <shlwapi.h>
#include <time.h>

#include "atsplugin.h"
#include "AtsIni.h"
#include "Logger.h"

using namespace std;

#pragma comment(lib, "shlwapi.lib")

CLogger::CLogger(void)
{
}

CLogger::~CLogger(void)
{
}

void CLogger::OnLoad(TCHAR *modulePath)
{
	TCHAR iniPath[ _MAX_PATH + 1 ] = _T( "" ); //t@CpXi[
	TCHAR csvPath[ _MAX_PATH + 1 ] = _T( "" ); //t@CpXi[
	TCHAR *posIni; //ւ̃|C^
	TCHAR *posCsv; //ւ̃|C^

	strcpy_s(iniPath, _MAX_PATH + 1, modulePath);
	strcpy_s(csvPath, _MAX_PATH + 1, modulePath);

	//pX.dll̈ʒu
	posIni = strstr(iniPath, _T(".dll"));
	posCsv = strstr(csvPath, _T(".dll"));

	//.dllu
	memmove(posIni, _T(".ini"), 4 * sizeof(TCHAR));
	memmove(posCsv, _T(".csv"), 4 * sizeof(TCHAR));

	//INIt@C[h
	AtsIni iniData;
	iniData.load(iniPath);

	// DLL̃fBNgpX擾
	PathRemoveFileSpec(iniPath);

	// ݎ̎擾
	time_t current;
    struct tm *local;

    time(&current);
    local = localtime(&current);

	// o̓t@CpXݒ
	outputPath << iniPath << "\\Log_";
	outputPath << setw(2) << setfill('0') << local->tm_year % 100;
	outputPath << setw(2) << setfill('0') << local->tm_mon + 1;
	outputPath << setw(2) << setfill('0') << local->tm_mday;
	outputPath << "-";
	outputPath << setw(2) << setfill('0') << local->tm_hour;
	outputPath << setw(2) << setfill('0') << local->tm_min;
	outputPath << setw(2) << setfill('0') << local->tm_sec;
	outputPath << ".csv";

	// INIt@Cݒ̓ǂݍ
	if(iniData.Frame.Skip < 1)
	{
		skip = 1;
	}
	else
	{
		skip = iniData.Frame.Skip;
	}

	// CSVt@C̓ǂݍ݂ƃwb_o^
	ifstream ifs(csvPath);

	string str; // s
	string element; // vf

	// CSVt@C̍sǂݍ
	while (ifs && getline(ifs, str))
	{
		int colCnt = 0; // JE^[
		string key; // L[x
		string header; // wb_eLXg

		// s𕶎Xg[
		istringstream row(str);

		// CSVt@C̗ǂݍ
		while (getline(row, element, ','))
		{
			// p[^̓o^
			switch(colCnt)
			{
			case 0:
				// 1ځiL[xj
				// 啶ɕϊ
				transform(element.begin(), element.end(), element.begin(), ::toupper);
				key = element;
				break;
			case 1:
				// 2ځiwb_eLXgj
				header = element;
				break;
			}
			
			colCnt++;
		}

		// L[Ewb_̗ǂݍ߂ꍇ̂ݒǉ
		if(colCnt >= 2)
		{
			order.push_back(key);
			buffer << header << ",";
		}
	}

	// s̏
	buffer << endl;
}

void CLogger::OnElapse(ATS_VEHICLESTATE state, int *panel, int *sound)
{
	frame++;

	// t[XLbv
	if(frame % skip != 0)
	{
		return;
	}

	// x̎Zo
	float acceleration;

	if(state.Time - prevTime != 0)
	{
		acceleration = 1000 * (state.Speed - prevSpeed) / (state.Time - prevTime);
	}
	else
	{
		acceleration = 0;
	}

	// Ot[̑xƎԂێ
	prevSpeed = state.Speed;
	prevTime = state.Time;

	// ~b玞(HH:MM:SS.000)
	stringstream ss;
	
	ss << setw(2) << setfill('0') << state.Time / (1000 * 60 * 60) << ":";
	ss << setw(2) << setfill('0') << state.Time / (1000 * 60) % 60 << ":";
	ss << setw(2) << setfill('0') << state.Time / 1000 % 60 << ".";
	ss << setw(3) << setfill('0') << state.Time % 1000;

	string time = ss.str();

	// li[
	SetDictionary("LOCATION", state.Location);
	SetDictionary("SPEED", state.Speed);
	SetDictionary("TIME", state.Time);
	SetDictionary("BC", state.BcPressure);
	SetDictionary("MR", state.MrPressure);
	SetDictionary("ER", state.ErPressure);
	SetDictionary("BP", state.BpPressure);
	SetDictionary("SAP", state.SapPressure);
	SetDictionary("CURRENT", state.Current);
	SetDictionary("ACCELERATION", acceleration);
	SetDictionary("TIME_HHMMSS", time);

	// o̓Oobt@֓̓f[^
	for(int i = 0; i < (int)order.size(); i++)
	{
		// L[dictionaryւ̑݃`FbN
		map<string, string>::iterator itr = dictionary.find(order[i]);
		if(itr != dictionary.end())
		{
			buffer << dictionary[order[i]] << ",";
		}
		else
		{
			buffer << ",";
		}
	}

	// s̏
	buffer << endl;
}

void CLogger::SaveLogFile(void)
{
	// Ot@Co͗pXg[쐬
	ofstream ofs(outputPath.str().c_str());

	// eLXgobt@t@Cɏo
	if(ofs)
	{
		ofs << buffer.rdbuf();
	}
}

void CLogger::SetDictionary(string label, string value)
{
	dictionary[label] = value;
}

void CLogger::SetDictionary(string label, double value)
{
	// doublestringɕϊ
	stringstream ss;
	ss << value;
	dictionary[label] = ss.str();
}

void CLogger::SetDictionary(string label, float value)
{
	// floatstringɕϊ
	stringstream ss;
	ss << value;
	dictionary[label] = ss.str();
}

void CLogger::SetDictionary(string label, int value)
{
	// intstringɕϊ
	stringstream ss;
	ss << value;
	dictionary[label] = ss.str();
}

void CLogger::SetDictionary(string label, bool value)
{
	if(value)
	{
		dictionary[label] = "true";
	}
	else
	{
		dictionary[label] = "false";
	}
}