#include "stdafx.h"
#include "atsplugin.h"
#include "Logger.h"
#include "Ats.h"

BOOL APIENTRY DllMain(HINSTANCE hModule,
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
		case DLL_THREAD_ATTACH:
			GetModuleFileName(hModule, g_module_path, MAX_PATH);
			break;
		case DLL_THREAD_DETACH:
		case DLL_PROCESS_DETACH:
			break;
    }

    return TRUE;
}
ATS_API void WINAPI Load()
{
	g_logger.OnLoad(g_module_path);
}

ATS_API void WINAPI Dispose()
{
	g_logger.SaveLogFile();
}

ATS_API int WINAPI GetPluginVersion()
{
	return ATS_VERSION;
}

ATS_API void WINAPI SetVehicleSpec(ATS_VEHICLESPEC spec)
{
}

ATS_API void WINAPI Initialize(int brake)
{
}

ATS_API ATS_HANDLES WINAPI Elapse(ATS_VEHICLESTATE state, int *panel, int *sound)
{
	g_logger.OnElapse(state, panel, sound);

	// nho
	g_output.Reverser = g_reverser;
	g_output.Power = g_powerNotch;
	g_output.Brake = g_brakeNotch;
	g_output.ConstantSpeed = ATS_CONSTANTSPEED_CONTINUE;

    return g_output;
}

ATS_API void WINAPI SetPower(int power)
{
	g_powerNotch = power;
	g_logger.SetDictionary("POWER", power);
}

ATS_API void WINAPI SetBrake(int brake)
{
	g_brakeNotch = brake;
	g_logger.SetDictionary("BRAKE", brake);
}

ATS_API void WINAPI SetReverser(int reverser)
{
	g_reverser = reverser;
	g_logger.SetDictionary("REVERSER", reverser);
}

ATS_API void WINAPI KeyDown(int keyCode)
{
}

ATS_API void WINAPI KeyUp(int keyCode)
{
}

ATS_API void WINAPI HornBlow(int keyCode)
{
}

ATS_API void WINAPI DoorOpen()
{
	g_logger.SetDictionary("PILOTLAMP", false);
}

ATS_API void WINAPI DoorClose()
{
	g_logger.SetDictionary("PILOTLAMP", true);
}

ATS_API void WINAPI SetSignal(int signal)
{
	g_logger.SetDictionary("SIGNAL", signal);
}

ATS_API void WINAPI SetBeaconData(ATS_BEACONDATA data)
{
	g_logger.SetDictionary("BEACON_TYPE", data.Type);
	g_logger.SetDictionary("BEACON_SIGNAL", data.Signal);
	g_logger.SetDictionary("BEACON_DISTANCE", data.Distance);
	g_logger.SetDictionary("BEACON_OPTIONAL", data.Optional);
}